/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.data;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.INbt;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.util.Util;

public class Data
implements IData {
    private static final NBTWrapper NBT_EMPTY = new NBTWrapper(new NBTTagCompound());
    protected final Map<String, Object> map = new TreeMap<String, Object>();
    protected NBTWrapper cacheNbt = NBT_EMPTY;

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public String[] getKeys() {
        Set<String> sets = this.map.keySet();
        return sets.toArray(new String[0]);
    }

    @Override
    public INbt getNbt() {
        CustomNpcs.debugData.start(this);
        if (this.cacheNbt == null) {
            this.cacheNbt = NBT_EMPTY;
            NBTBase tag = Util.instance.writeObjectToNbt(this.map);
            if (tag instanceof NBTTagCompound) {
                this.cacheNbt = new NBTWrapper((NBTTagCompound)tag);
            }
        }
        CustomNpcs.debugData.end(this);
        return this.cacheNbt;
    }

    @Override
    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public void put(String key, Object value) {
        this.cacheNbt = null;
        if (value == null) {
            this.remove(key);
            return;
        }
        this.map.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    public void setNbt(NBTTagCompound compound) {
        CustomNpcs.debugData.start(this);
        Object obj = Util.instance.readObjectFromNbt((NBTBase)compound);
        if (obj instanceof TreeMap) {
            try {
                this.map.clear();
                this.map.putAll((TreeMap)obj);
                this.cacheNbt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CustomNpcs.debugData.end(this);
    }

    @Override
    public void setNbt(INbt nbt) {
        this.setNbt(nbt.getMCNBT());
    }
}

